<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareMobile\PickProfile;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\Dispatch\Dispatch;

/**
 * @ORM\Entity()
 * @ORM\Table(name="pickware_wms_pick_profile_stock_filter_exempt_dispatch_methods", uniqueConstraints={
 *      @ORM\UniqueConstraint(name="pickProfileId_dispatchMethodId", columns={
 *          "pickProfileId",
 *          "dispatchMethodId"
 *      })
 * })
 */
class PickProfileStockBasedOrderFilterExemptDispatchMethod extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Id
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="pickProfileId", type="integer", nullable=false)
     */
    private $pickProfileId;

    /**
     * @var int
     *
     * @ORM\Column(name="dispatchMethodId", type="integer", nullable=false)
     */
    private $dispatchMethodId;

    /**
     * OWNING SIDE
     *
     * @var PickProfile
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareMobile\PickProfile\PickProfile", inversedBy="stockBasedOrderFilterExemptDispatchMethods")
     * @ORM\JoinColumn(name="pickProfileId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $pickProfile;

    /**
     * OWNING SIDE
     *
     * @var Dispatch
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Dispatch\Dispatch")
     * @ORM\JoinColumn(name="dispatchMethodId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $dispatchMethod;

    /**
     * @param PickProfile $pickProfile
     * @param Dispatch $dispatchMethod
     */
    public function __construct(PickProfile $pickProfile, Dispatch $dispatchMethod)
    {
        $this->pickProfile = $pickProfile;
        $this->dispatchMethod = $dispatchMethod;
        if (!$this->pickProfile->getStockBasedOrderFilterExemptDispatchMethods()->contains($this)) {
            $this->pickProfile->getStockBasedOrderFilterExemptDispatchMethods()->add($this);
        }

        // Explicitly set the both IDs which form the unique identifier of this entity, because Doctrine won't do it,
        // even though we have already set the associated entities
        $this->pickProfileId = $pickProfile->getId();
        $this->dispatchMethodId = $dispatchMethod->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return PickProfile
     */
    public function getPickProfile()
    {
        return $this->pickProfile;
    }

    /**
     * @return Dispatch
     */
    public function getDispatchMethod()
    {
        return $this->dispatchMethod;
    }
}
