<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareMobile\PickedQuantity;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_wms_picked_quantity_stock_ledger_entry_mappings")
 */
class StockLedgerEntryMapping extends ModelEntity
{
    /**
     * @var int $id
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Id
     */
    protected $id;

    /**
     * @var int $pickedQuantityId
     *
     * @ORM\Column(name="pickedQuantityId", type="integer", nullable=false)
     */
    protected $pickedQuantityId;

    /**
     * OWNING SIDE
     *
     * @var PickedQuantity $pickedQuantity
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareMobile\PickedQuantity\PickedQuantity", inversedBy="stockLedgerEntryMappings")
     * @ORM\JoinColumn(name="pickedQuantityId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $pickedQuantity;

    /**
     * @var int
     *
     * @ORM\Column(name="stockLedgerEntryId", type="integer", nullable=false)
     */
    protected $stockLedgerEntryId;

    /**
     * OWNING SIDE
     *
     * @var StockLedgerEntry
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry")
     * @ORM\JoinColumn(name="stockLedgerEntryId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $stockLedgerEntry;

    /**
     * @param PickedQuantity $pickedQuantity;
     * @param StockLedgerEntry $stockLedgerEntry;
     */
    public function __construct(PickedQuantity $pickedQuantity, StockLedgerEntry $stockLedgerEntry)
    {
        $this->pickedQuantity = $pickedQuantity;
        $this->pickedQuantity->getStockLedgerEntryMappings()->add($this);
        $this->stockLedgerEntry = $stockLedgerEntry;

        // Explicitely set the both IDs which form the unique identifier of this entity, because Doctrine
        // won't do it, even though we have already set the assocaited entities
        $this->pickedQuantityId = $pickedQuantity->getId();
        $this->stockLedgerEntryId = $stockLedgerEntry->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return PickedQuantity
     */
    public function getPickedQuantity()
    {
        return $this->pickedQuantity;
    }

    /**
     * @return StockLedgerEntry
     */
    public function getStockLedgerEntry()
    {
        return $this->stockLedgerEntry;
    }
}
