<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class IndexSubscriber extends Base
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Action_PostDispatchSecure_Backend_Index' => 'onPostDispatchSecureIndex',
        ];
    }

    /**
     * Adds custom extensions to the loaded sub application, which cannot be loaded using
     * ViisonCommon's sub application loader.
     *
     * @param \Enlight_Event_EventArgs $args
     */
    public function onPostDispatchSecureIndex(\Enlight_Event_EventArgs $args)
    {
        if ($args->getRequest()->getActionName() === 'index') {
            $view = $args->getSubject()->View();
            $view->extendsTemplate('backend/viison_pickware_mobile/base/header.tpl');
        }
    }
}
