<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Backend\VariantGeneration as BaseVariantGeneration;

class VariantGenerationSubscriber extends BaseVariantGeneration
{
    /**
     * @inheritdoc
     */
    protected function getBlockedArticleDetailFields()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    protected function getBlockedArticleAttributeFields()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    protected function getBlockedArticleAttributeFieldsMappingOnly()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    protected function getCopiedArticleAttributeFields()
    {
        return [
            'pickwareNotRelevantForPicking',
        ];
    }

    /**
     * @inheritdoc
     */
    protected function processGeneratedVariants(array $variants)
    {
        // Nothing to do
    }
}
