<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers\BarcodeLabel;

use Enlight_Event_EventArgs;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickingBoxBarcodeLabel\PickingBoxBarcodeLabelType;

class PickingBoxBarcodeLabelTypeSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Plugins_ViisonPickwareERP_CollectSupportedBarcodeLabelTypes' => 'onCollectSupportedBarcodeLabelTypes',
        ];
    }

    /**
     * Returns the barcode label types supported by this plugin.
     *
     * @param $args
     */
    public function onCollectSupportedBarcodeLabelTypes(Enlight_Event_EventArgs $args)
    {
        return new PickingBoxBarcodeLabelType(
            $this->get('pickware.erp.plugin_config_service'),
            $this->get('snippets'),
            $this->get('pickware.erp.barcode_label.barcode_renderer_service')
        );
    }
}
