<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers\Components;

use Shopware\Models\Order\Detail as OrderDetail;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonPickwareERP\Components\OrderDetailQuantityCalculator\OrderDetailQuantityCalculatorService;

class OrderDetailQuantityCalculatorServiceSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritDoc
     */
    public static function getSubscribedEvents()
    {
        return [
            OrderDetailQuantityCalculatorService::class . '::calculateRemainingQuantityToShip::after' => 'onCalculateRemainingQuantityToShip',
        ];
    }

    /**
     * @param \Enlight_Hook_HookArgs $args
     */
    public function onCalculateRemainingQuantityToShip(\Enlight_Hook_HookArgs $args)
    {
        /** @var OrderDetail $orderDetail */
        $orderDetail = $args->get('orderDetail');

        // Picked quantities are not left for shipping because mobile will handle shipping
        $pickedQuantity = $orderDetail->getAttribute()->getPickwarePickedQuantity();
        $args->setReturn($args->getReturn() - $pickedQuantity);
    }
}
