<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers;

use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\RequestLogging\AbstractRestApiRequestLogFilterSubscriber;

class RestApiRequestLogFilterSubscriber extends AbstractRestApiRequestLogFilterSubscriber
{
    /**
     * @inheritdoc
     */
    public function filterLoggedResponseJson(array $responseJson, \Enlight_Controller_Request_Request $request)
    {
        // Only filter responses of GETting order shipping documents or PUTting order return labels
        $isShippingDocumentsGet = $request->getMethod() === 'GET' && $request->getParam('shippingDocuments') !== null;
        $isReturnLabelsPut = $request->getMethod() === 'PUT' && $request->getParam('returnLabels') !== null;
        if ($request->getParam('controller') !== 'orders' || (!$isShippingDocumentsGet && !$isReturnLabelsPut)) {
            return $responseJson;
        }

        if (isset($responseJson['data']['fileData'])) {
            $responseJson['data']['fileData'] = '<TRUNCATED>';
        }

        return $responseJson;
    }
}
