<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers;

use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Routing\AbstractRestApiRouterSubscriber;

class RestApiRouterSubscriber extends AbstractRestApiRouterSubscriber
{
    /**
     * @inheritdoc
     */
    public function applyCustomRouting(\Enlight_Controller_Request_Request $request)
    {
        $controller = $request->getParam('controller');
        $method = $request->getMethod();

        if ($controller === 'orders'
            && (
                ($method === 'GET' && $request->getParam('shippingDocuments') !== null)
                || ($method === 'POST' && ($request->getParam('shippingDocuments') !== null || $request->getParam('returnShipments') !== null))
                || (($method === 'POST' || $method === 'PUT' || $method === 'DELETE') && $request->getParam('details') !== null && $request->getParam('pickedQuantities') === '')
                || ($method === 'DELETE' && $request->getParam('details') !== null && $request->getParam('stockReservations') === '')
                || ($method === 'PUT' && ($request->getActionName() === 'batch' || $request->getParam('lock') !== null || $request->getParam('returnLabels') !== null))
            )
        ) {
            return 'ViisonPickwareMobileOrders';
        }

        if ($controller === 'stockLedgerEntries' && $method === 'PUT' && $request->getParam('stockItems') !== null) {
            return 'ViisonPickwareMobileStockLedgerEntries';
        }

        if ($controller === 'supplierOrders'
            && (
                ($method === 'GET' && ($request->getParam('action') === null || $request->getParam('action') === 'index'))
                || ($method === 'PUT' && $request->getParam('id') !== false)
                || ($method === 'POST' && $request->getParam('items') !== null && $request->getParam('purchases') === '')
            )
        ) {
            return 'ViisonPickwareMobileSupplierOrders';
        }

        if ($controller === 'pickingBoxes'
            && (
                ($method === 'GET' && ($request->getParam('action') === null || $request->getParam('action') === 'index'))
                || ($method === 'PUT' && $request->getParam('id') !== false)
            )
        ) {
            return 'ViisonPickwareMobilePickingBoxes';
        }

        if ($controller === 'pickProfiles' && $method === 'GET' && $request->getParam('estimatedNumberOfOrdersInWarehouse') !== null) {
            return 'ViisonPickwareMobilePickProfiles';
        }

        if ($controller === 'variants' && $method === 'POST' && ($request->getParam('relocations') !== null || $request->getParam('stock') !== null || $request->getParam('stocktakes') !== null)) {
            return 'ViisonPickwareMobileVariants';
        }

        if ($controller === 'warehouses'
            && (
                ($method === 'GET' && ($request->getParam('action') === 'index' || $request->getParam('binLocations') !== null))
                || ($method === 'POST' && $request->getParam('binLocations') !== null)
            )
        ) {
            return 'ViisonPickwareMobileWarehouses';
        }

        return null;
    }
}
