<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonPickwareMobile\Components\Decorators\ViisonPickwareERP\OrderDocumentCreationIdempotencyDecorator;

class ServiceDecorationSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Bootstrap_AfterInitResource_pickware.erp.order_document_creation_service' => 'onAfterInitDocumentCreationService',
        ];
    }

    /**
     * Adds a decorator on 'pickware.erp.order_document_creation_service'.
     *
     * @param \Enlight_Event_EventArgs $args
     */
    public function onAfterInitDocumentCreationService(\Enlight_Event_EventArgs $args)
    {
        $decoratedService = $args->get('subject')->get('pickware.erp.order_document_creation_service');
        $args->get('subject')->set(
            'pickware.erp.order_document_creation_service',
            new OrderDocumentCreationIdempotencyDecorator($decoratedService, $this->get('models'))
        );
    }
}
