<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers;

use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as CommonServicesSubscriber;
use Shopware\Plugins\ViisonPickwareMobile\Components\DocumentComponentListenerService;
use Shopware\Plugins\ViisonPickwareMobile\Components\OrderPickingService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickedQuantityUpdaterService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickingOrderFilter\OrderFilterConditionQueryComponent\OrderFilterConditionQueryComponentFactoryService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickingOrderFilter\OrderItemRelevance\OrderItemRelevanceService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickingOrderFilter\PickingOrderFilterConditionLocalizationService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickingOrderFilter\PickingOrderFilterService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickProfile\PickProfileOrderFilterOptionFactoryService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickProfile\PickProfileOrderFilterService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PickProfile\PickProfilesService;
use Shopware\Plugins\ViisonPickwareMobile\Components\PluginConfigService;
use Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding\QueryComponentArrayCodingService;
use Shopware\Plugins\ViisonPickwareMobile\Components\ShippingProviderRepositoryService;
use Shopware\Plugins\ViisonPickwareMobile\Components\StockReservationService;

class ServicesSubscriber extends CommonServicesSubscriber
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services::getServices()
     */
    public static function getServices()
    {
        return [
            'viison_pickware_mobile.order_filter_condition_query_component_factory_service' => function (Container $container) {
                return new OrderFilterConditionQueryComponentFactoryService(
                    $container->get('viison_pickware_mobile.query_component_array_coding_service')
                );
            },
            'viison_pickware_mobile.order_item_relevance_service' => function (Container $container) {
                return new OrderItemRelevanceService(
                    $container->get('db')
                );
            },
            'viison_pickware_mobile.order_picking_service' => function (Container $container) {
                return new OrderPickingService(
                    $container->get('db')
                );
            },
            'viison_pickware_mobile.plugin_config' => function (Container $container, \Enlight_Config $pluginConfig) {
                return new PluginConfigService(
                    $container->get('viison_common.hidden_config_storage'),
                    $pluginConfig
                );
            },
            'viison_pickware_mobile.pick_profiles_service' => function (Container $container) {
                return new PickProfilesService(
                    $container->get('models'),
                    $container->get('viison_pickware_mobile.query_component_array_coding_service')
                );
            },
            'viison_pickware_mobile.pick_profile_order_filter_option_factory_service' => function (Container $container) {
                return new PickProfileOrderFilterOptionFactoryService(
                    $container->get('shopware_attribute.crud_service'),
                    $container->get('db')
                );
            },
            'viison_pickware_mobile.pick_profile_order_filter_service' => function (Container $container) {
                return new PickProfileOrderFilterService(
                    $container->get('viison_pickware_mobile.picking_order_filter_service'),
                    $container->get('viison_pickware_mobile.order_filter_condition_query_component_factory_service')
                );
            },
            'viison_pickware_mobile.picked_quantity_updater' => function (Container $container) {
                return new PickedQuantityUpdaterService(
                    $container->get('models'),
                    $container->get('snippets'),
                    $container->get('pickware.erp.stock_ledger_service'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('pickware.erp.stock_item_updater_service')
                );
            },
            'viison_pickware_mobile.picking_order_filter_condition_localization_service' => function (Container $container) {
                return new PickingOrderFilterConditionLocalizationService(
                    $container->get('viison_common.snippet_manager')
                );
            },
            'viison_pickware_mobile.picking_order_filter_service' => function (Container $container) {
                // Determine whether the debug mode is enabled. You can enable it by adding the following to shopware's
                // config.php:
                //
                // 'viison_pickware_mobile' => [
                //     'picking_order_filter_debugging' => true,
                // ],
                $debugModeEnabled = (
                    $container->hasParameter('shopware.viison_pickware_mobile.picking_order_filter_debugging')
                    && $container->getParameter('shopware.viison_pickware_mobile.picking_order_filter_debugging')
                );

                return new PickingOrderFilterService(
                    $container->get('db'),
                    $container->get('viison_pickware_mobile.shipping_provider_repository'),
                    $container->get('viison_pickware_mobile.order_item_relevance_service'),
                    $container->get('viison_common.logger'),
                    $debugModeEnabled
                );
            },
            'viison_pickware_mobile.query_component_array_coding_service' => function (Container $container) {
                return new QueryComponentArrayCodingService();
            },
            'viison_pickware_mobile.shipping_provider_repository' => function (Container $container) {
                return new ShippingProviderRepositoryService($container->get('events'));
            },
            'viison_pickware_mobile.stock_reservation' => function (Container $container) {
                return new StockReservationService(
                    $container->get('models'),
                    $container->get('pickware.erp.stock_reservation_service'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('pickware.erp.derived_property_updater_service'),
                    $container->get('pickware.erp.order_detail_quantity_calculator_service')
                );
            },
            'viison_pickware_mobile.document_component_listener_service' => function (Container $container) {
                return new DocumentComponentListenerService(
                    $container->get('events'),
                    $container->get('models'),
                    $container->get('viison_pickware_mobile.plugin_config'),
                    $container->get('pickware.erp.order_detail_quantity_calculator_service')
                );
            },
        ];
    }
}
