<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;
use Shopware\Plugins\ViisonPickwareMobile\Classes\ShippingProvider\ShippingProvider as ShippingProviderClass;
use Shopware\Plugins\ViisonPickwareMobile\Components\ShippingProviderRepositoryService;

class ShippingProviderSubscriber extends Base
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            ShippingProviderRepositoryService::EVENT_COLLECT_SHIPPING_PROVIDERS => 'onCollectShippingProviders',
        ];
    }

    /**
     * Creates and returns a new ShippingProvider instance.
     *
     * @param \Enlight_Event_EventArgs $args
     * @return \Shopware\Plugins\ViisonPickwareMobile\Classes\ShippingProvider\ShippingProvider
     */
    public function onCollectShippingProviders(\Enlight_Event_EventArgs $args)
    {
        return new ShippingProviderClass($this->get('dbal_connection'), $this->getPluginConfig());
    }
}
