<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Subscribers;

use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\AbstractSubApplicationRegistrationSubscriber;

class SubApplicationRegistrationSubscriber extends AbstractSubApplicationRegistrationSubscriber
{
    /**
     * @inheritdoc
     */
    public function createSubApplications()
    {
        $this->addModelExtension('ViisonPickwareMobileOrderModelExtensions')
            ->extendingSubApplication('Order');

        $this->addSubApplicationExtension('ViisonPickwareMobileAnalyticsPickTimes')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplication('ViisonCommonAnalytics');

        $this->addSubApplicationExtension('ViisonPickwareMobileOrderPickedQuantityColumn')
            ->extendingSubApplication('Order');

        $this->addSubApplicationExtension('ViisonPickwareMobileOrderPickingFilterVisualization')
            ->extendingSubApplication('Order')
            ->requiringSubApplications([
                'ViisonCommonComboBox',
                'ViisonPickwareERPWarehouseManagement',
                'ViisonPickwareMobilePickProfiles',
            ]);

        $this->addSubApplicationExtension('ViisonPickwareMobileOrderInternalPickingInstructions')
            ->extendingSubApplication('Order');

        $this->addSubApplicationExtension('ViisonPickwareMobileOrderStatusBasedPositionUpdate')
            ->extendingSubApplication('ViisonPickwareERPOrderStatusBasedPositionUpdate')
            ->requiringSubApplications([
                'ViisonPickwareERPOrderEventBus',
                'ViisonShippingCommonOrder',
            ]);

        $this->addSubApplicationExtension('ViisonPickwareMobileOrderUndispatchedTrackingCodes')
            ->extendingSubApplication('Order');

        $this->addSubApplicationExtension('ViisonPickwareMobilePickingBoxBarcodeLabelPrinting')
            ->extendingSubApplication('ViisonPickwareERPBarcodeLabelPrinting');

        $this->addSubApplication('ViisonPickwareMobilePickProfiles')
            ->requiringSubApplications([
                'ViisonCommonComboBox',
                'ViisonCommonPaginationToolbar',
            ]);

        if ($this->get('viison_pickware_mobile.plugin_config')->getDisplayAboutPickwareMobileWindow()) {
            $this->addSubApplicationExtension('ViisonPickwareMobileIndexAboutPopup')
                ->extendingSubApplication('Index')
                ->requiringSubApplication('ViisonCommonIndexPopup');
        }
    }
}
