// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileAnalyticsPickTimes.store.Navigation', {

    override: 'Shopware.apps.Analytics.store.Navigation',

    constructor: function (config) {
        this.root.children.push({
            text: ViisonCommonApp.getSnippet('nav/pickTimes', 'backend/viison_pickware_mobile_analytics/pick_times'),
            id: 'pick-times',
            iconCls: 'sprite-clock',
            store: 'analytics-store-navigation-pick-times',
            multiShop: true, // To have the default selectedShops widget (for languageId queries).
            leaf: true,
            viisonCommonAnalysisId: 'Shopware.apps.ViisonPickwareMobileAnalyticsPickTimes',
        });

        this.callParent([config]);
    },

});
