// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderInternalPickingInstructions.controller.Detail', {

    override: 'Shopware.apps.Order.controller.Detail',

    /**
     * @Override
     */
    init: function () {
        this.callParent(arguments);

        this.control({
            'order-detail-window order-communication-panel': {
                saveInternalPickingInstructions: this.onSaveInternalPickingInstructions,
            },
        });
    },

    /**
     * Event listener method which is fired when the user wants to save the internal picking instructions
     * which can be edit in the communication tab panel on the detail page.
     */
    onSaveInternalPickingInstructions: function (record, panel, options) {
        this.saveRecord(
            record,
            ViisonCommonApp.getSnippet(
                'communication/internal_picking_instructions/success_message',
                'backend/viison_pickware_mobile_order_internal_picking_instructions/main'
            ),
            ViisonCommonApp.getSnippet(
                'communication/internal_picking_instructions/failure_message',
                'backend/viison_pickware_mobile_order_internal_picking_instructions/main'
            ),
            options
        );
    },

});
