// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderInternalPickingInstructions.view.detail.Communication', {

    override: 'Shopware.apps.Order.view.detail.Communication',

    /**
     * @Override
     */
    createInternalElements: function () {
        var items = this.callParent(arguments);

        return items.concat(this.createInternalPickingInstructionsElements());
    },

    /**
     * @Override
     */
    registerEvents: function () {
        this.addEvents(
            'saveInternalPickingInstructions'
        );
        this.callParent(arguments);
    },

    /**
     * @return Array
     */
    createInternalPickingInstructionsElements: function () {
        this.internalPickingInstructionsDescriptionContainer = Ext.create('Ext.container.Container', {
            style: {
                color: '#999',
                fontStyle: 'italic',
                margin: '0 0 15px 0',
            },
            html: ViisonCommonApp.getSnippet(
                'communication/internal_picking_instructions/description',
                'backend/viison_pickware_mobile_order_internal_picking_instructions/main'
            ),
        });

        this.internalPickingInstructionsTextArea = Ext.create('Ext.form.field.TextArea', {
            name: 'pickwareWmsInternalPickingInstructions',
            height: 90,
            anchor: '100%',
            cols: 4,
            allowBlank: true,
            grow: true,
        });

        this.internalPickingInstructionsSaveButton = Ext.create('Ext.button.Button', {
            style: {
                margin: '8px 0',
            },
            cls: 'small primary',
            text: ViisonCommonApp.getSnippet(
                'communication/internal_picking_instructions/save',
                'backend/viison_pickware_mobile_order_internal_picking_instructions/main'
            ),
            scope: this,
            handler: function () {
                this.record.set('pickwareWmsInternalPickingInstructions', this.internalPickingInstructionsTextArea.getValue());
                this.fireEvent('saveInternalPickingInstructions', this.record, this);
            },
        });

        return [
            this.internalPickingInstructionsDescriptionContainer,
            this.internalPickingInstructionsTextArea,
            this.internalPickingInstructionsSaveButton,
        ];
    },

});
