// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickedQuantityColumn.view.detail.Position', {

    override: 'Shopware.apps.Order.view.detail.Position',

    /*
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Add a new (hidden) column for the picked quantity
        columns.splice(3, 0, {
            dataIndex: 'pickwarePickedQuantity',
            header: ViisonCommonApp.getSnippet('column/pickware_picked_quantity/header', 'backend/viison_pickware_mobile_order_picked_quantity_column/main'),
            width: 60,
            hidden: true,
        });

        return columns;
    },

});
