// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.controller.Filter', {
    override: 'Shopware.apps.Order.controller.Filter',

    /**
     * @Override
     */
    init: function () {
        this.control({
            'viison_pickware_mobile_order_picking_filter_visualization-list-pick_profile_selection': {
                evaluatePickProfileFilter: this.onEvaluatePickProfileFilter,
            },
            'viison_pickware_mobile_order_picking_filter_visualization-list-pick_profile_selection viison_common_combo_box-combo_box': {
                pickProfileChanged: this.onPickingOrderFilterPickProfileChanged,
            },
            'viison_pickware_mobile_order_picking_filter_visualization-list-pick_profile_selection viison_pickware_erp_warehouse_management-warehouse_combo_box': {
                warehouseChanged: this.onPickingOrderFilterWarehouseChanged,
            },
        });

        this.callParent(arguments);
    },

    /**
     * Reloads the main order store to apply any changes in the pick profile filter settings.
     */
    onEvaluatePickProfileFilter: function () {
        this.subApplication.getStore('Order').loadPage(1);
    },

    /**
     * Adds the pick profile's ID to the extra params of the main order store's proxy.
     *
     * @param {Shopware.apps.ViisonPickwareMobilePickProfiles.model.PickProfile} pickProfile
     */
    onPickingOrderFilterPickProfileChanged: function (pickProfile) {
        if (pickProfile) {
            var store = this.subApplication.getStore('Order');
            store.getProxy().extraParams.viisonPickwareMobilePickingOrderFilterPickProfileId = pickProfile.get('id');
        }
    },

    /**
     * Adds the warehouse's ID to the extra params of the main order store's proxy.
     *
     * @param {Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse} warehouse
     */
    onPickingOrderFilterWarehouseChanged: function (warehouse) {
        if (warehouse) {
            var store = this.subApplication.getStore('Order');
            store.getProxy().extraParams.viisonPickwareMobilePickingOrderFilterWarehouseId = warehouse.get('id');
        }
    },
});
