// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.store.PickingAppVisiblityFilterOptions', {

    extend: 'Ext.data.Store',
    autoLoad: true,
    fields: [
        { name: 'id', type: 'int' },
        { name: 'name', type: 'string' },
        {
            name: 'displayName',
            type: 'string',
            convert: function (value, record) {
                var snippet = ViisonCommonApp.getSnippet(
                    'list/filter/field/picking_app_visibility/option/' + record.get('name'),
                    'backend/viison_pickware_mobile_order_picking_filter_visualization'
                );

                return snippet || record.get('name');
            },
        },
    ],
    data: [
        { id: 1, name: 'yes' },
        { id: 0, name: 'no' },
    ],

});
