// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.view.detail.Position', {

    override: 'Shopware.apps.Order.view.detail.Position',

    /**
     * First calls the parent method to get the default columns, before adding
     * a new column for the Picking app visibility.
     *
     * @param grid The grid for which the columns are created.
     * @return An array containing all columns for the given grid.
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Add a new column for the visibility in the Picking app
        var pickingVisibilityColumn = Ext.create('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.view.PickingVisibilityColumn', {
            snippets: {
                visible: ViisonCommonApp.getSnippet(
                    'detail/position/column/picking_app_visiblity/tooltip/visible',
                    'backend/viison_pickware_mobile_order_picking_filter_visualization'
                ),
                hidden: ViisonCommonApp.getSnippet(
                    'detail/position/column/picking_app_visiblity/tooltip/hidden',
                    'backend/viison_pickware_mobile_order_picking_filter_visualization'
                ),
            },
        });
        columns = columns.concat(pickingVisibilityColumn);

        return columns;
    },

});
