// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.view.list.Filter', {

    override: 'Shopware.apps.Order.view.list.Filter',

    /**
     * @override
     *
     * Adds a new filter option for filtering orders based on the stock of their items.
     */
    createFilterForm: function () {
        var form = this.callParent(arguments);

        // Create and add a combobox for filtering the order list based on the visibility in the picking app
        var pickwarePickingAppVisibilityFilter = Ext.create('Shopware.apps.ViisonCommonComboBox.view.ComboBox', {
            name: 'viisonPickwareMobilePickingAppVisibility',
            fieldLabel: ViisonCommonApp.getSnippet(
                'list/filter/field/picking_app_visibility/label',
                'backend/viison_pickware_mobile_order_picking_filter_visualization'
            ),
            store: Ext.create('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.store.PickingAppVisiblityFilterOptions'),
            displayField: 'displayName',
            allowBlank: true,
            emptyText: ViisonCommonApp.getSnippet(
                'list/filter/field/picking_app_visibility/empty_text',
                'backend/viison_pickware_mobile_order_picking_filter_visualization'
            ),
        });
        form.insert(form.items.length, pickwarePickingAppVisibilityFilter);

        // Create and add a new filter option for stock based filtering
        var pickwareStockFilter = Ext.create('Ext.form.field.Checkbox', {
            name: 'viisonPickwareMobileWaitingForStock',
            fieldLabel: ViisonCommonApp.getSnippet(
                'list/filter/field/waiting_for_stock/label',
                'backend/viison_pickware_mobile_order_picking_filter_visualization'
            ),
            helpText: Ext.String.format(
                ViisonCommonApp.getSnippet(
                    'list/filter/field/waiting_for_stock/help_text',
                    'backend/viison_pickware_mobile_order_picking_filter_visualization'
                ),
                ViisonCommonApp.getSnippet(
                    'list/pick_profile_selection/title',
                    'backend/viison_pickware_mobile_order_picking_filter_visualization'
                )
            ),
            inputValue: true,
        });
        form.insert(form.items.length, pickwareStockFilter);

        return form;
    },

});
