// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.view.list.Navigation', {

    override: 'Shopware.apps.Order.view.list.Navigation',

    /**
     * @override
     */
    getPanels: function () {
        var panels = this.callParent(arguments);

        // Prepend a collpased pick profile selection panel
        var pickProfileSelection = Ext.create(
            'Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.view.list.PickProfileSelection',
            {
                collapsed: true,
            }
        );
        panels.splice(0, 0, pickProfileSelection);

        // Make all panels collapsible
        panels.forEach(function (panel) {
            panel.collapsible = true;
            panel.collapseDirection = 'top';
        });

        return panels;
    },

});
