// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderPickingFilterVisualization.view.list.PickProfileSelection', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_mobile_order_picking_filter_visualization-list-pick_profile_selection',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_order_picking_filter_visualization',
    autoScroll: true,
    layout: 'anchor',
    defaults: {
        anchor: '95%',
        border: false,
        margin: 10,
    },

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('list/pick_profile_selection/title');
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @return {Ext.Component[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'container',
                layout: 'anchor',
                defaults: {
                    anchor: '100%',
                },
                items: [
                    {
                        xtype: 'viison_common_combo_box-combo_box',
                        name: 'pickProfile',
                        pageSize: 10,
                        initialValue: parseInt(localStorage.getItem('pickware-OrderPickingFilter-lastSelectedPickProfileId'), 10),
                        store: Ext.create('Shopware.apps.ViisonPickwareMobilePickProfiles.store.PickProfile', {
                            autoLoad: true,
                            pageSize: 10,
                        }),
                        displayField: 'name',
                        fieldLabel: this.getViisonSnippet('list/pick_profile_selection/field/pick_profile/label'),
                        changeEventName: 'pickProfileChanged',
                        listeners: {
                            pickProfileChanged: function (pickProfile) {
                                if (pickProfile === null) {
                                    return;
                                }
                                localStorage.setItem('pickware-OrderPickingFilter-lastSelectedPickProfileId', pickProfile.get('id'));
                            },
                        },
                    },
                    {
                        xtype: 'viison_pickware_erp_warehouse_management-warehouse_combo_box',
                        name: 'warehouse',
                        helpText: this.getViisonSnippet('list/pick_profile_selection/field/warehouse/help_text'),
                    },
                ],
            },
            {
                xtype: 'container',
                items: [
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('list/pick_profile_selection/button/evaluate_pick_profile_filter/text'),
                        cls: 'primary small',
                        scope: this,
                        handler: function () {
                            this.fireEvent('evaluatePickProfileFilter', this);
                        },
                    },
                ],
            },
        ];
    },
});
