// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderStatusBasedPositionUpdate.controller.Batch', {

    override: 'Shopware.apps.Order.controller.Batch',

    /**
     * @Override
     */
    onProcessChanges: function (form, options) {
        var newStatus = form.getValues().orderStatus;
        var statusCancelledRejected = 4;
        var statusOpen = 0;

        var someOrderHasPickedQuantities = Ext.Array.some(form.records, function (record) {
            // Check if any order has a picked quantity, so we can show a alert for the user to choose the bin location for cancellation.
            return ViisonPickwarePickedQuantities.getTotalOfOrder(record) !== 0;
        }, this);

        if (this.viisonSkipStatusBasedPositionUpdateAlert || !someOrderHasPickedQuantities || [statusCancelledRejected, statusOpen].indexOf(newStatus) === -1) {
            this.callParent(arguments);
            this.viisonSkipStatusBasedPositionUpdateAlert = false;

            return;
        }

        // this.callParent() cannot be called asynchronous (in the callback of the MsgBox), therefore we save the
        // super method in a local variable an call that in the callback instead.
        // Determine the superMethod like ExtJS does
        var getCurrentFunction = function () {
            return getCurrentFunction.caller;
        };
        var method = getCurrentFunction();
        var superMethod = method.$previous || (
            (method = method.$owner ? method : method.caller) && method.$owner.superclass[method.$name]
        );

        ViisonPickwareBatchLocationAlertMessage.show({
            scope: this,
            callback: function (buttonId) {
                if (buttonId === 'cancel') {
                    return;
                }

                if (buttonId === 'yes') {
                    ViisonPickwareERPOrderEventBus.on(
                        'collectBatchStoreParams',
                        function (store) {
                            store.getProxy().extraParams.pickwareMoveStockToOriginalLocation = 1;
                        },
                        this,
                        {
                            single: true,
                        }
                    );
                } else {
                    ViisonPickwareERPOrderEventBus.on(
                        'collectBatchStoreParams',
                        function (store) {
                            store.getProxy().extraParams.pickwareMoveStockToOriginalLocation = 0;
                        },
                        this,
                        {
                            single: true,
                        }
                    );
                }

                superMethod.apply(this, [form, options]);
            },
        });
    },

});
