// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderStatusBasedPositionUpdate.controller.BatchLocationAlertMessage', {

    alternateClassName: 'ViisonPickwareBatchLocationAlertMessage',

    statics: {
        /**
         * @param {function} configuration
         */
        show: function (configuration) {
            var defaultConfiguration = {
                title: Ext.String.format(
                    ViisonCommonApp.getSnippet('dialog/choose_bin_location/title', 'backend/viison_pickware_mobile_order_status_based_position_update/main')
                ),
                msg: ViisonCommonApp.getSnippet('dialog/choose_bin_location/message', 'backend/viison_pickware_mobile_order_status_based_position_update/main'),
                icon: Ext.Msg.QUESTION,
                buttons: Ext.Msg.YESNOCANCEL,
                buttonText: {
                    yes: ViisonCommonApp.getSnippet('dialog/choose_bin_location/button/original_bin_location', 'backend/viison_pickware_mobile_order_status_based_position_update/main'),
                    no: ViisonCommonApp.getSnippet('dialog/choose_bin_location/button/null_bin_location', 'backend/viison_pickware_mobile_order_status_based_position_update/main'),
                },
            };

            // Merge configuration to default configuration.
            Object.assign(defaultConfiguration, configuration);

            Ext.Msg.show(defaultConfiguration);
        },
    },
});
