// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderStatusBasedPositionUpdate.controller.Detail', {

    override: 'Shopware.apps.Order.controller.Detail',

    viisonSkipMovePositionsPickingAlert: false,

    /**
     * @Override
     */
    onSaveOverview: function (record, options) {
        var detailWindow = this.getDetailWindow();
        if (!detailWindow) {
            return;
        }

        var statusOpen = 0;
        var statusCancelledRejected = 4;
        var orderStatusComboBox = detailWindow.down('combobox[name=status]');
        var totalPickedQuantity = ViisonPickwarePickedQuantities.getTotalOfOrder(record);
        var isOrderStatusOpenOrCancelled = orderStatusComboBox && [statusOpen, statusCancelledRejected].indexOf(orderStatusComboBox.getValue()) !== -1;
        if (this.viisonSkipMovePositionsPickingAlert || totalPickedQuantity === 0 || !isOrderStatusOpenOrCancelled) {
            this.viisonSkipMovePositionsPickingAlert = false;
            this.callParent(arguments);

            return;
        }

        // this.callParent() cannot be called asynchronous (in the callback of the MsgBox), therefore we save the
        // super method in a local variable an call that in the callback instead.
        // Determine the superMethod like ExtJS does
        var getCurrentFunction = function () {
            return getCurrentFunction.caller;
        };
        var method = getCurrentFunction();
        var superMethod = method.$previous || (
            (method = method.$owner ? method : method.caller) && method.$owner.superclass[method.$name]
        );

        ViisonPickwareBatchLocationAlertMessage.show({
            scope: this,
            msg: Ext.String.format(
                ViisonCommonApp.getSnippet(
                    'dialog/choose_bin_location/single/message',
                    'backend/viison_pickware_mobile_order_status_based_position_update/main'
                ),
                record.get('number')
            ),
            callback: function (buttonId) {
                if (buttonId === 'cancel') {
                    this.viisonClearProxyParams(record);

                    return;
                }

                if (buttonId === 'yes') {
                    record.getProxy().extraParams.pickwareMoveStockToOriginalLocation = 1;
                } else {
                    record.getProxy().extraParams.pickwareMoveStockToOriginalLocation = 0;
                }

                this.viisonSkipMovePositionsPickingAlert = true;
                superMethod.apply(this, [record, options]);
            },
        });
    },

    /**
     * To make sure that the property is not saved (no side-effect) after the alert is closed.
     *
     * @Override
     */
    viisonClearProxyParams: function (order) {
        delete order.getProxy().extraParams.pickwareMoveStockToOriginalLocation;
    },

});
