// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderStatusBasedPositionUpdate.controller.PickedQuantities', {

    alternateClassName: 'ViisonPickwarePickedQuantities',

    statics: {
        /**
         * @param {Shopware.apps.Order.model.Order} order
         * @returns {Number}
         */
        getTotalOfOrder: function (order) {
            return order.getPositions().getRange().map(function (position) {
                return position.get('pickwarePickedQuantity');
            }).reduce(function (accumulator, currentValue) {
                return accumulator + currentValue;
            }, 0);
        },
    },
});
