// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobileOrderUndispatchedTrackingCodes.view.detail.Overview', {

    override: 'Shopware.apps.Order.view.detail.Overview',

    /**
     * First calls the parent method to get the default elements, before a new
     * element for the undispatched tracking codes is added.
     *
     * @return Ext.Component[]
     */
    createEditElements: function () {
        var elements = this.callParent(arguments);

        // Add a new text field for the undispatched tracking codes
        elements.splice(2, 0, {
            xtype: 'textfield',
            name: 'viisonUndispatchedTrackingCodes',
            fieldLabel: ViisonCommonApp.getSnippet(
                'field_label',
                'backend/viison_pickware_mobile_order_undispatched_tracking_codes/main'
            ),
        });

        return elements;
    },

});
