// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.model.PickProfile', {

    extend: 'Ext.data.Model',
    fields: [
        {
            name: 'id',
            type: 'int',
        },
        {
            name: 'name',
            type: 'string',
        },
        {
            name: 'stockBasedOrderFilterMode',
            type: 'int',
            defaultValue: 0,
        },
        {
            name: 'advanceDaysForPreOrderedItems',
            type: 'int',
            defaultValue: 3,
        },
        {
            name: 'prioritizedDispatchMethods',
            type: 'object',
            defaultValue: [],
        },
        {
            name: 'prioritizedPaymentMethods',
            type: 'object',
            defaultValue: [],
        },
        {
            name: 'stockBasedOrderFilterExemptDispatchMethods',
            type: 'object',
            defaultValue: [],
        },
        {
            name: 'orderFilterQueryConditions',
            type: 'object',
            defaultValue: null,
            useNull: true,
        },
    ],
    statics: {
        /**
         * The default configuration for a single rule component. Use this when adding new rule components to a
         * profile's `orderFilterQueryConditions`.
         *
         * @type {Object}
         */
        createDefaultRuleDescription: function () {
            return {
                type: 'comparison',
                leftOperand: {
                    type: 'fieldDescriptor',
                    tableName: 's_order',
                    fieldName: 'cleared',
                },
                operator: 'IN',
                rightOperand: {
                    type: 'scalarValue',
                    value: [0], // 0 = 'open'
                },
            };
        },
    },

    constructor: function (data) {
        data = data || {};
        if (!data.orderFilterQueryConditions) {
            // Add a conjunction rule containing a single default rule component
            data.orderFilterQueryConditions = {
                type: 'booleanComposition',
                booleanOperator: 'AND',
                compositionComponents: [
                    this.statics().createDefaultRuleDescription(),
                ],
            };
        }

        this.callParent(arguments);
    },

});
