// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.model.rule.Field', {

    extend: 'Ext.data.Model',
    fields: [
        {
            name: 'id',
            type: 'string',
        },
        {
            name: 'name',
            type: 'string',
        },
        {
            name: 'valueType',
            type: 'string',
        },
        {
            name: 'store',
            type: 'auto',
            useNull: true,
        },
        {
            name: 'isNullable',
            type: 'boolean',
        },
    ],

    /**
     * @return {string}
     */
    getEffectiveValueType: function () {
        switch (this.get('valueType')) {
            case 'store':
                return this.get('store').name;
            default:
                return this.get('valueType');
        }
    },

});
