// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.model.rule.Operator', {

    extend: 'Ext.data.Model',
    fields: [
        {
            name: 'id',
            type: 'string',
        },
        {
            name: 'value',
            type: 'string',
        },
        {
            name: 'type',
            type: 'string',
        },
        {
            name: 'name',
            type: 'string',
            convert: function (value, record) {
                return ViisonCommonApp.getSnippet('rule/operator/' + record.get('id') + '/name', 'backend/viison_pickware_mobile_pick_profiles/main') || record.get('value');
            },
        },
        {
            name: 'supportedValueTypes',
            type: 'auto',
        },
        {
            name: 'requiresNullability',
            type: 'boolean',
        },
    ],

    /**
     * @param {string} valueType
     * @return {boolean}
     */
    supportsValueOfType: function (valueType) {
        return this.get('supportedValueTypes').indexOf(valueType) > -1;
    },

});
