// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.model.rule.Reference', {

    extend: 'Ext.data.Model',
    fields: [
        {
            name: 'id',
            type: 'string',
        },
        {
            name: 'name',
            type: 'string',
            convert: function (value, record) {
                var id = record.get('id');

                return ViisonCommonApp.getSnippet('rule/reference/' + id + '/name', 'backend/viison_pickware_mobile_pick_profiles/rule_options') || id;
            },
        },
        {
            name: 'groupingConstraints',
            type: 'auto',
            convert: function (value) {
                if (!Ext.isArray(value) || value.length === 0) {
                    return null;
                }

                return value.map(function (constraint) {
                    var localizedConstraint = ViisonCommonApp.getSnippet(
                        'rule/reference_grouping_constraint/' + constraint + '/name',
                        'backend/viison_pickware_mobile_pick_profiles/main'
                    );

                    return {
                        id: constraint,
                        name: localizedConstraint || constraint,
                    };
                });
            },
        },
        {
            name: 'fields',
            type: 'auto',
            convert: function (value, ruleReference) {
                var attributePrefix = ViisonCommonApp.getConfig(
                    'attributeFilterOptionPrefix',
                    'ViisonPickwareMobilePickProfiles'
                );
                var referenceId = ruleReference.get('id');

                return Object.keys(value).map(function (id) {
                    var fieldData = value[id];
                    fieldData.id = id;
                    if (id.indexOf(attributePrefix) === 0) {
                        var prefix = ViisonCommonApp.getSnippet(
                            'rule/attribute_field_prefix',
                            'backend/viison_pickware_mobile_pick_profiles/rule_options'
                        );
                        fieldData.name = prefix + ': ' + id.substr(attributePrefix.length);
                    } else {
                        fieldData.name = ViisonCommonApp.getSnippet(
                            'rule/reference/' + referenceId + '/field/' + id + '/name',
                            'backend/viison_pickware_mobile_pick_profiles/rule_options'
                        );
                        fieldData.name = fieldData.name || id;
                    }

                    return fieldData;
                });
            },
        },
    ],

});
