// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.view.Edit', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_mobile_pick_profiles-edit',
    cls: 'viison_pickware_mobile_pick_profiles-edit viison-common--window has--no-border has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_pick_profiles/main',

    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    autoShow: true,
    width: '90%',
    height: '95%',
    border: false,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return {Object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'panel',
                layout: {
                    type: 'vbox',
                    align: 'stretch',
                },
                width: 380,
                autoScroll: true,
                cls: 'viison-common--sidebar has--no-border is--left-sidebar',
                items: [
                    {
                        xtype: 'viison_pickware_mobile_pick_profiles-edit-settings',
                        pickProfile: this.pickProfile,
                    },
                    {
                        xtype: 'viison_pickware_mobile_pick_profiles-edit-order_filter_settings',
                        pickProfile: this.pickProfile,
                    },
                ],
            },
            {
                xtype: 'viison_pickware_mobile_pick_profiles-edit-order_filter_rules',
                flex: 1,
                pickProfile: this.pickProfile,
            },
        ];
    },

    /**
     * @return {Object[]}
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui is--viison-common--button-panel',
                items: [
                    {
                        xtype: 'viison_pickware_mobile_pick_profiles-edit-order_filter_preview',
                        flex: 1,
                    },
                    {
                        xtype: 'tbspacer',
                        width: 50,
                    },
                    {
                        text: this.getViisonSnippet('edit/toolbar/button/cancel'),
                        cls: 'secondary',
                        action: 'cancel',
                    },
                    {
                        text: this.getViisonSnippet('edit/toolbar/button/save'),
                        cls: 'primary',
                        action: 'save',
                    },
                ],
            },
        ];
    },

});
