// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.view.edit.OrderFilterPreview', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_mobile_pick_profiles-edit-order_filter_preview',
    cls: 'viison_pickware_mobile_pick_profiles-edit-order_filter_preview',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_pick_profiles/main',

    layout: 'hbox',
    border: false,
    defaults: {
        margin: 5,
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @return {Object[]}
     */
    createItems: function () {
        this.loadingIndicator = Ext.create('Ext.Component', {
            html: [
                '<b>',
                this.getViisonSnippet('edit/order_filter_preview/label/loading'),
                '</b>',
            ].join(''),
            flex: 1,
            hidden: true,
        });
        this.executionTimeLabel = Ext.create('Ext.Component', {
            data: {
                executionTime: '-',
            },
            tpl: [
                '<b>',
                this.getViisonSnippet('edit/order_filter_preview/label/execution_time'),
                ':</b> {executionTime}',
            ].join(''),
            flex: 1,
        });
        this.resultCountLabel = Ext.create('Ext.Component', {
            data: {
                resultCount: '-',
            },
            tpl: [
                '<b>',
                this.getViisonSnippet('edit/order_filter_preview/label/result_count'),
                ':</b> {resultCount}',
            ].join(''),
            flex: 1,
        });
        this.errorMessageLabel = Ext.create('Ext.Component', {
            data: {
                message: '',
            },
            tpl: [
                '<b>',
                this.getViisonSnippet('edit/order_filter_preview/label/error'),
                ':</b> {message}',
            ].join(''),
            style: {
                color: '#FF0000',
            },
            maxWidth: 600,
            hidden: true,
        });
        this.labelContainer = Ext.create('Ext.container.Container', {
            layout: 'hbox',
            flex: 1,
            items: [
                this.executionTimeLabel,
                this.resultCountLabel,
                this.errorMessageLabel,
            ],
        });

        return [
            {
                xtype: 'tbspacer',
                width: 10,
            },
            this.loadingIndicator,
            this.labelContainer,
        ];
    },

    /**
     * @param {boolean} loading
     */
    setLoading: function (loading) {
        this.loadingIndicator.setVisible(loading);
        this.labelContainer.setVisible(!loading);
    },

    /**
     * @param {number|null} executionTime
     * @param {number|null} resultCount
     */
    updateFilterEstimateLabels: function (executionTime, resultCount) {
        // Hide the error label
        this.errorMessageLabel.setVisible(false);

        // Update and show computation time label
        var formattedExecutionTime = '-';
        if (Ext.isNumber(executionTime)) {
            formattedExecutionTime = [
                this.getViisonSnippet('edit/order_filter_preview/label/execution_time/ca_prefix'),
                Ext.util.Format.number(Math.max(0.1, executionTime), '0.0'),
                this.getViisonSnippet('edit/order_filter_preview/label/execution_time/seconds_suffix'),
            ].join(' ');
        }
        this.executionTimeLabel.update({
            executionTime: formattedExecutionTime,
        });
        this.executionTimeLabel.setVisible(true);

        // Update and show result count label
        this.resultCountLabel.update({
            resultCount: (Ext.isNumber(resultCount)) ? resultCount : '-',
        });
        this.resultCountLabel.setVisible(true);
    },

    /**
     * @param {string|null} message
     */
    displayErrorMessage: function (message) {
        // Hide the result labels
        this.executionTimeLabel.setVisible(false);
        this.resultCountLabel.setVisible(false);

        // Update and show error label
        this.errorMessageLabel.update({
            message: message || this.getViisonSnippet('edit/order_filter_preview/label/error/default_error_message'),
        });
        this.errorMessageLabel.setVisible(true);
    },
});
