// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.view.edit.OrderFilterRules', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_mobile_pick_profiles-edit-order_filter_rules',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_pick_profiles/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    autoScroll: true,

    style: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderTop: '1px solid #a4b5c0 !important',
        borderBottom: 'none !important',
    },
    bodyStyle: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderTop: '1px solid rgba(71, 92, 106, 0.3) !important',
        borderBottom: 'none !important',
    },

    /**
     * @property {Shopware.apps.ViisonPickwareMobilePickProfiles.model.PickProfile} pickProfile
     */
    pickProfile: undefined,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return {Shopware.apps.ViisonPickwareMobilePickProfiles.view.edit.OrderFilterRuleEditor[]}
     */
    createItems: function () {
        this.rootEditor = Ext.create('Shopware.apps.ViisonPickwareMobilePickProfiles.view.edit.OrderFilterRuleEditor', {
            ruleDescription: (this.pickProfile.get('orderFilterQueryConditions')) ? Ext.clone(this.pickProfile.get('orderFilterQueryConditions')) : null,
            border: false,
        });

        return [
            this.rootEditor,
        ];
    },

    /**
     * @return {object[]}
     */
    createDockedItems: function () {
        return [{
            xtype: 'toolbar',
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            items: [{
                xtype: 'button',
                text: this.getViisonSnippet('edit/order_filter_rules/toolbar/button/add_rule/title'),
                iconCls: 'sprite-plus-circle-frame',
                scope: this,
                handler: function () {
                    this.fireEvent('extendRule', this);
                },
            }],
        }];
    },

});
