// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.view.edit.OrderFilterSettings', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_mobile_pick_profiles-edit-order_filter_settings',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonConfigNamespace: 'ViisonPickwareMobilePickProfiles',
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_pick_profiles/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    /**
     * @property {Shopware.apps.ViisonPickwareMobilePickProfiles.model.PickProfile} pickProfile
     */
    pickProfile: undefined,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);

        this.loadRecord(this.pickProfile);
    },

    /**
     * @return {Ext.form.field.Base[]}
     */
    createItems: function () {
        var stockBasedOrderFilterModeStore = Ext.create('Ext.data.Store', {
            fields: [
                'id',
                'name',
            ],
            data: this.getViisonConfig('stockBasedOrderFilterModes').map(function (filterMode) {
                return {
                    id: filterMode,
                    name: this.getViisonSnippet('edit/order_filter_settings/field/stock_based_order_filter_mode/mode_' + filterMode),
                };
            }.bind(this)),
        });
        var dispatchMethodStore = Ext.create('Shopware.apps.Base.store.Dispatch', {
            // The store is filtered by default, hence we have to clear all filters
            filters: [],
        });
        dispatchMethodStore.load();

        var stockBasedOrderFilterModeOptions = [];
        stockBasedOrderFilterModeStore.each(function (mode) {
            stockBasedOrderFilterModeOptions.push({
                name: 'stockBasedOrderFilterMode',
                boxLabel: mode.get('name'),
                inputValue: mode.get('id'),
            });
        }, this);

        return [{
            xtype: 'box',
            cls: 'is--settings-sub-header',
            html: this.getViisonSnippet('edit/order_filter_settings/title'),
        }, {
            xtype: 'radiogroup',
            hideLabel: true,
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            cls: 'is--radio-group',
            items: stockBasedOrderFilterModeOptions,
        }, {
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('edit/order_filter_settings/field/stock_based_order_filter_exempt_dispatch_methods/label') + ':',
            margin: '15 10 6 0',
        }, {
            xtype: 'combobox',
            name: 'stockBasedOrderFilterExemptDispatchMethods',
            hideLabel: true,
            helpText: this.getViisonSnippet('edit/order_filter_settings/field/stock_based_order_filter_exempt_dispatch_methods/help_text'),
            width: 500,
            store: dispatchMethodStore,
            valueField: 'id',
            displayField: 'name',
            allowBlank: true,
            editable: false,
            autoSelect: false,
            forceSelection: true,
            multiSelect: true,
        }, {
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('edit/order_filter_settings/field/advance_days_for_pre_ordered_items/label') + ':',
            margin: '10 10 6 0',
        }, {
            xtype: 'numberfield',
            name: 'advanceDaysForPreOrderedItems',
            hideLabel: true,
            helpText: this.getViisonSnippet('edit/order_filter_settings/field/advance_days_for_pre_ordered_items/help_text'),
            allowBlank: false,
            minValue: 0,
        }];
    },

});
