// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.view.edit.Settings', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_mobile_pick_profiles-edit-settings',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_pick_profiles/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    /**
     * @property {Shopware.apps.ViisonPickwareMobilePickProfiles.model.PickProfile} pickProfile
     */
    pickProfile: undefined,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);

        this.loadRecord(this.pickProfile);
    },

    /**
     * @return {Ext.form.field.Base[]}
     */
    createItems: function () {
        var dispatchMethodStore = Ext.create('Shopware.apps.Base.store.Dispatch', {
            // The store is filtered by default, hence we have to clear all filters
            filters: [],
        });
        dispatchMethodStore.load();
        var paymentMethodStore = Ext.create('Shopware.apps.Base.store.Payment');
        paymentMethodStore.load();

        return [{
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('edit/settings/field/name/label') + ':',
            margin: '0 10 6 0',
        }, {
            xtype: 'textfield',
            name: 'name',
            hideLabel: true,
            allowBlank: false,
        }, {
            xtype: 'box',
            cls: 'is--settings-sub-header',
            html: this.getViisonSnippet('edit/settings/prioritization/title'),
        }, {
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('edit/settings/field/prioritized_dispatch_methods/label') + ':',
            margin: '0 10 6 0',
        }, {
            xtype: 'combobox',
            name: 'prioritizedDispatchMethods',
            hideLabel: true,
            helpText: this.getViisonSnippet('edit/settings/field/prioritized_dispatch_methods/help_text'),
            store: dispatchMethodStore,
            valueField: 'id',
            displayField: 'name',
            allowBlank: true,
            editable: false,
            autoSelect: false,
            forceSelection: true,
            multiSelect: true,
        }, {
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('edit/settings/field/prioritized_payment_methods/label') + ':',
            margin: '10 10 6 0',
        }, {
            xtype: 'combobox',
            name: 'prioritizedPaymentMethods',
            hideLabel: true,
            helpText: this.getViisonSnippet('edit/settings/field/prioritized_payment_methods/help_text'),
            store: paymentMethodStore,
            valueField: 'id',
            displayField: 'description',
            allowBlank: true,
            editable: false,
            autoSelect: false,
            forceSelection: true,
            multiSelect: true,
        }];
    },

});
