// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickProfiles.view.main.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_mobile_pick_profiles-main-list',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_pick_profiles/main',
    cls: 'viison-common--grid has--vertical-lines',
    style: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderBottom: 'none !important',
    },
    bodyStyle: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
    },
    split: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
        markDirty: false,
        deferEmptyText: false,
    },

    /**
     * @override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('main/list/empty_text');
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return {Ext.grid.column.Column[]}
     */
    createColumns: function () {
        // Create a function for getting snippets that's always bound to this component. We need this, because we cannot
        // bind an action item's `getClass()` method to `this`.
        var getSnippet = this.getViisonSnippet.bind(this);

        return [{
            dataIndex: 'name',
            header: this.getViisonSnippet('main/list/column/name'),
            flex: 1,
        }, {
            xtype: 'actioncolumn',
            align: 'center',
            width: 80,
            items: [{
                iconCls: 'sprite-pencil',
                action: 'editPickProfile',
                tooltip: this.getViisonSnippet('main/list/tooltip/edit'),
                scope: this,
                handler: function (grid, rowIndex) {
                    this.fireEvent('editPickProfile', grid.getStore().getAt(rowIndex));
                },
            }, {
                iconCls: 'sprite-minus-circle',
                action: 'deletePickProfile',
                handler: function (grid, rowIndex) {
                    if (grid.getStore().getTotalCount() > 1) {
                        this.fireEvent('deletePickProfile', grid.getStore().getAt(rowIndex));
                    }
                }.bind(this),
                getClass: function (value, meta, pickProfile) {
                    if (pickProfile.store.getTotalCount() === 1) {
                        this.items[1].tooltip = getSnippet('main/list/tooltip/delete/disabled');

                        return 'is--disabled';
                    }

                    this.items[1].tooltip = getSnippet('main/list/tooltip/delete');

                    return '';
                },
            }, {
                iconCls: 'sprite-blue-document-copy',
                action: 'duplicatePickProfile',
                tooltip: this.getViisonSnippet('main/list/tooltip/duplicate'),
                scope: this,
                handler: function (grid, rowIndex) {
                    this.fireEvent('duplicatePickProfile', grid.getStore().getAt(rowIndex));
                },
            }],
        }];
    },

    /**
     * @return {Ext.toolbar.Toolbar[]}
     */
    createDockedItems: function () {
        // Create a toolbar located at the top, containing a button for creating a new pick profile as well as
        // search field
        var topToolbar = Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            items: [
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('main/list/toolbar/button/add'),
                    iconCls: 'sprite-plus-circle-frame',
                    action: 'addPickProfile',
                },
                '->',
                {
                    xtype: 'textfield',
                    name: 'searchfield',
                    cls: 'searchfield',
                    width: 170,
                    enableKeyEvents: true,
                    emptyText: this.getViisonSnippet('main/list/toolbar/search_field/placeholder'),
                    listeners: {
                        buffer: 500,
                        scope: this,
                        change: function (field) {
                            this.fireEvent('searchFieldChanged', field.value);
                        },
                    },
                },
            ],
        });

        // Create a paging toolbar located at the bottom
        var bottomToolbar = {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        };

        return [
            topToolbar,
            bottomToolbar,
        ];
    },

});
