// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickingBoxBarcodeLabelPrinting.controller.Main', {

    override: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.controller.Main',

    /**
     * @Override
     */
    init: function () {
        this.control({
            'viison_pickware_erp_barcode_label_printing [action=printBatchPickingBoxLabels]': {
                click: this.onPrintBatchPickingBoxLabels,
            },
        });

        this.callParent(arguments);
    },

    /**
     * Renders the barcode label p
     *
     * @param {Ext.button.Button} button
     */
    onPrintBatchPickingBoxLabels: function (button) {
        var form = button.up('viison_pickware_erp_barcode_label_printing [customIdentifier=tabParent]').getForm();

        // Check if the form is valid
        if (!form.isValid()) {
            return;
        }

        // Open the PDF in a new window
        var values = form.getValues();
        var params = JSON.stringify({
            start: values.batchPickingBoxStart,
            end: values.batchPickingBoxEnd,
        });
        var url = ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/renderBarcodeLabels', {
            // If startX/startY fields are disabled (i.e. custom label format), use fallback values.
            startX: values.startX || 1,
            startY: values.startY || 1,
            preset: 7,
            type: 'picking_box',
            params: params,
        });
        window.open(url, '_blank');
    },

});
