// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickingBoxPrinting.view.Main', {

    override: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.Main',

    pickingBoxTab: null,

    /**
     * Adds the customer card tab to the tabs for other barcode labels.
     *
     * @param {Object} presetStore
     */
    getTabs: function (presetStore) {
        this.pickingBoxTab = Ext.create('Shopware.apps.ViisonPickwareMobilePickingBoxBarcodeLabelPrinting.view.PickingBoxLabels', {
            title: ViisonCommonApp.getSnippet('tab/title', 'backend/viison_pickware_mobile_picking_box_barcode_label_printing/main'),
            presetStore: presetStore,
        });

        var tabs = this.callParent([presetStore]);
        tabs.push(this.pickingBoxTab);

        return tabs;
    },

    /**
     * Activates the customer card tab.
     */
    activatePickingBoxTab: function () {
        Ext.ComponentQuery.query('viison_pickware_erp_barcode_label_printing [name=main-tab]')[0].setActiveTab(this.pickingBoxTab);
    },

});
