// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareMobilePickingBoxBarcodeLabelPrinting.view.PickingBoxLabels', {

    extend: 'Ext.form.Panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_mobile_picking_box_barcode_label_printing/main',

    cls: 'viison_pickware_mobile_barcode_label_printing_picking_box_labels',
    layout: 'fit',
    border: false,
    bodyStyle: {
        border: 'none',
    },
    customIdentifier: 'tabParent',
    listeners: {
        activate: function () {
            this.presetStore.clearFilter();
            var preset = this.presetStore.findRecord('type', 'picking_box');

            if (preset) {
                this.down('viison_pickware_erp_barcode_label_printing_preset_print_settings').setPreset(preset);
            }
        },
    },

    initComponent: function () {
        var customerGroupStore = Ext.create('Shopware.store.CustomerGroup', {
            storeId: undefined,
        });
        customerGroupStore.load();

        var shopStore = Ext.create('Shopware.store.Shop', {
            shopId: undefined,
        });
        shopStore.load();

        this.items = [
            {
                xtype: 'container',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'stretch',
                },
                height: '100%',
                items: [
                    {
                        xtype: 'container',
                        cls: 'is--image-picking-trolley',
                        flex: 1,
                        border: false,
                        layout: 'fit',
                        items: [
                            {
                                xtype: 'container',
                                style: {
                                    border: 'none',
                                    borderRight: '1px solid #a4b5c0 !important',
                                },
                            },
                        ],
                    },
                    {
                        xtype: 'container',
                        width: 350,
                        border: false,
                        padding: 20,
                        style: {
                            backgroundColor: '#ECEDEF',
                        },
                        layout: {
                            type: 'vbox',
                            align: 'stretch',
                        },
                        items: [
                            {
                                xtype: 'viison_pickware_erp_barcode_label_printing_preset_print_settings',
                                presetName: this.getViisonSnippet('preset/batch_picking_standard_name'),
                                presetStore: this.presetStore,
                            },
                            {
                                xtype: 'tbspacer',
                                height: 15,
                            },
                            {
                                xtype: 'label',
                                cls: 'is--viison-common--label',
                                text: this.getViisonSnippet('picking_labels/fields/start_number') + ':',
                                margin: '0 0 5 0',
                            },
                            {
                                xtype: 'numberfield',
                                cls: 'is--viison-common--numberfield',
                                name: 'batchPickingBoxStart',
                                hideLabel: true,
                                helpText: this.getViisonSnippet('picking_labels/tooltips/start_number'),
                                value: 1,
                                minValue: 1,
                                allowDecimals: false,
                                anchor: '100%',
                                validator: function (value) {
                                    return (value <= this.down('numberfield[name=batchPickingBoxEnd]').getValue()) || this.getViisonSnippet('picking_labels/validation_error');
                                }.bind(this),
                            },
                            {
                                xtype: 'tbspacer',
                                height: 15,
                            },
                            {
                                xtype: 'label',
                                cls: 'is--viison-common--label',
                                text: this.getViisonSnippet('picking_labels/fields/end_number') + ':',
                                margin: '0 0 5 0',
                            },
                            {
                                xtype: 'numberfield',
                                cls: 'is--viison-common--numberfield',
                                name: 'batchPickingBoxEnd',
                                hideLabel: true,
                                helpText: this.getViisonSnippet('picking_labels/tooltips/start_number'),
                                value: 10,
                                minValue: 1,
                                allowDecimals: false,
                                anchor: '100%',
                                validator: function (value) {
                                    return (value >= this.down('numberfield[name=batchPickingBoxStart]').getValue()) || this.getViisonSnippet('picking_labels/validation_error');
                                }.bind(this),
                            },
                        ],
                    },
                ],
            },
        ];

        this.dockedItems = [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui',
                cls: 'shopware-toolbar is--viison-common--button-panel is--primary',
                items: [
                    {
                        xtype: 'tbfill',
                    }, {
                        text: ViisonCommonApp.getSnippet('toolbar/buttons/cancel', 'backend/viison_pickware_erp_barcode_label_printing/main'),
                        cls: 'secondary',
                        action: 'cancel',
                    },
                    {
                        text: this.getViisonSnippet('toolbar/buttons/print_barcode_labels', 'backend/viison_pickware_erp_barcode_label_printing/main'),
                        cls: 'primary',
                        action: 'printBatchPickingBoxLabels',
                    },
                ],
            },
        ];

        this.callParent(arguments);
    },

});
