{namespace name="documents/viison_pickware_mobile/delivery_note"}
{extends file="parent:documents/index_ls.tpl"}

{* Use the comment block on the last page of the document to add our hint snippet *}
{block name="document_index_info_comment"}
    {$smarty.block.parent}
    {if $viisonHasRemainingPositions}
        <p>{s name="remainingPositions/hint"}{/s}</p>
    {/if}
{/block}

{* Use the document_index_info block which is displayed on the last page of the document) and add the attachment page
 after this page *}
{block name="document_index_info"}
    {$smarty.block.parent}
    {if $viisonHasRemainingPositions}
        {* Close the page and start a new page for the positions *}
        <div id="footer">
            {$Containers.Footer.value}
        </div>
        <pagebreak />
        <div id="head_logo">
            {$Containers.Logo.value}
        </div>

        {block name="document_remaining_positions_header"}
            <h1>{s name="remainingPositions/title"}{/s} {$Order._order.ordernumber}</h1>
        {/block}

        {* Show article table (similar to regular invoice document) *}
        {block name="document_remaining_articles"}
            <div id="content">
                <table cellpadding="0" cellspacing="0" width="100%">
                    <tbody valign="top">
                    <tr>
                        {block name="document_remaining_positions_table_head_pos"}
                            <td align="left" width="5%" class="head">
                                <strong>{s namespace="documents/index" name="DocumentIndexHeadPosition"}{/s}</strong>
                            </td>
                        {/block}
                        {block name="document_remaining_positions_table_head_nr"}
                            <td align="left" width="10%" class="head">
                                <strong>{s namespace="documents/index" name="DocumentIndexHeadArticleID"}{/s}</strong>
                            </td>
                        {/block}
                        {block name="document_remaining_positions_table_head_name"}
                            <td align="left" width="48%" class="head">
                                <strong>{s namespace="documents/index" name="DocumentIndexHeadName"}{/s}</strong>
                            </td>
                        {/block}
                        {block name="document_remaining_positions_table_head_quantity"}
                            <td align="right" width="5%" class="head">
                                <strong>{s namespace="documents/index" name="DocumentIndexHeadQuantity"}{/s}</strong>
                            </td>
                        {/block}
                    </tr>

                    {foreach from=$viisonRemainingPositions item=remainingPosition key=number}
                        {block name="document_remaining_positions_table_each"}
                            <tr>
                                {block name="document_remaining_positions_table_pos"}
                                    <td align="left" width="5%" valign="top">
                                        {$number+1}
                                    </td>
                                {/block}
                                {block name="document_remaining_positions_table_nr"}
                                    <td align="left" width="10%" valign="top">
                                        {$remainingPosition.ordernumber|truncate:14:""}
                                    </td>
                                {/block}
                                {block name="document_remaining_positions_table_name"}
                                    <td align="left" width="48%" valign="top">
                                        {s name="DocumentIndexPositionNameDefault"}{$remainingPosition.name|nl2br|wordwrap:65:"<br />\n"}{/s}
                                    </td>
                                {/block}
                                {block name="document_remaining_positions_table_quantity"}
                                    <td align="right" width="5%" valign="top">
                                        {$remainingPosition.remainingQuantity}
                                    </td>
                                {/block}
                            </tr>
                        {/block}
                    {/foreach}

                    </tbody>
                </table>
            </div>
        {/block}
    {/if}

{/block}
