<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\ValidationExceptions;

use Exception;

class CustomValidationException extends AbstractValidationException
{
    /**
     * @param string $parameterName
     * @param mixed $parameterValue
     * @param string $explanation A sentence that explains whats going wrong.
     * @param Exception|null $previousException
     */
    public function __construct($parameterName, $parameterValue, $explanation, Exception $previousException = null)
    {
        $message = sprintf(
            'Parameter "%s" has unexpected value "%s". %s',
            $parameterName,
            $parameterValue,
            $explanation
        );

        parent::__construct(
            $message,
            'customValidationException',
            [
                $parameterName,
                $parameterValue,
                $explanation,
            ],
            $previousException
        );
    }
}
