<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation;

/**
 * Interface to post process a translated message of a Throwable
 *
 * Example: If the translation has placeholders, the postProcess function could be sprintf
 *
 * @deprecated Use LocalizableThrowable instead
 */
interface FormattedTranslatableThrowable extends TranslatableThrowable
{
    /**
     * Formats the translated message
     *
     * @param $translatedMessage
     * @return string
     */
    public function format($translatedMessage);
}
