<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

if (!class_exists('ViisonCommon_Plugin_BootstrapV9')) {
    require_once('PluginBootstrapV9.php');
}

abstract class ViisonCommon_Plugin_BootstrapV10 extends ViisonCommon_Plugin_BootstrapV9
{
    /**
     * {@inheritdoc}
     *
     * @deprecated Do not use/override this method, implement self::runUpdate() instead.
     */
    public function install()
    {
        $this->preventRedeclareClassError();

        // Don't call `parent::install()` here, because that would result in another call to `runUpdate()`, which we
        // call in this implementation too.
        return $this->executeSetupMethod(
            'Installation',
            function () {
                // We have to explicitly register the 'Shopware_Console_Add_Command' subscriber here, even though that
                // subscriber used to be added by Bootstrap v6. However, since we forgot to call `parent::update()` in
                // the implementation of `install()` in Bootstrap v8, there's no way of correctly calling the parent
                // methods exactly once.
                $this->subscribeEvent('Shopware_Console_Add_Command', 'addViisonCommonConsoleCommands');

                // We have to explicitly import the snippets here, even though they used to be imported by Bootstrap v1.
                // However, since we forgot to call `parent::update()` in the implementation of `install()` in
                // Bootstrap v8, there's no way of correctly calling the parent methods exactly once.
                $this->importViisonCommonSnippetsIntoDb();

                $this->runUpdate('install');
            }
        );
    }
}
