{extends file="backend/base/header.tpl"}

{block name="backend/base/header/css" append}
    <style>
        {include file='_resources/viison_common/css/viison_common_analytics.css'}
        {include file='_resources/viison_common/css/viison_common_explanation_area.css'}
        {include file='_resources/viison_common/css/viison_common_form.css'}
        {include file='_resources/viison_common/css/viison_common_grid.css'}
        {include file='_resources/viison_common/css/viison_common_hint_panel.css'}
        {include file='_resources/viison_common/css/viison_common_icons.css'}
        {include file='_resources/viison_common/css/viison_common_info_panel.css'}
        {include file='_resources/viison_common/css/viison_common_mail_composer.css'}
        {include file='_resources/viison_common/css/viison_common_migration.css'}
        {include file='_resources/viison_common/css/viison_common_pagination_toolbar.css'}
        {include file='_resources/viison_common/css/viison_common_sidebar.css'}
        {include file='_resources/viison_common/css/viison_common_tab_panel.css'}
        {include file='_resources/viison_common/css/viison_common_toolbar.css'}
        {include file='_resources/viison_common/css/viison_common_tooltip.css'}
        {include file='_resources/viison_common/css/viison_common_various.css'}
        {include file='_resources/viison_common/css/viison_common_window.css'}
    </style>
{/block}

{block name="backend/base/header/javascript" append}
    <script type="text/javascript">
        (/**
         * Sets up a persistent Ext.js's state provider to remember view state, such as displayed or hidden columns in
         * a grid.
         *
         * By default Shopware does not register a custom state provider when the backend is initialized. Unfortunately
         * the default state provider is non-persistent. Hence we need to replace the default state provider with a
         * persistent one (local storage) in order to support "real" state persistence. Since Shopware itself replaces
         * the default provider in some of its components (e.g., the article list), we replace the registered state
         * provider only in case that it is non persistent.
         */
        function setupGlobalStateProviderSingleton () {
            if (!Ext.state
                || !Ext.state.Manager
                || !Ext.state.Manager.getProvider
                || !Ext.state.LocalStorageProvider
            ) {
                // Protect against odd environment. Should never happen.
                return;
            }

            var currentStateProvider = Ext.state.Manager.getProvider();

            if (currentStateProvider
                && Object.getPrototypeOf(currentStateProvider) !== Ext.state.Provider.prototype
            ) {
                // If currentStateProvider is defined and is _not_ the default implementation, do nothing.
                // The default implementation, Ext.state.Provider, does not persist the state.
                // We assume any other implementation is good enough for us, or that we are the ones who have already
                // configured another implementation.
                return;
            }

            // currentStateProvider is either not set, or the default Provider, Ext.state.Provider, which does not
            // persist state on its own.
            // Hence, we replace it with a persisting provider:
            Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider());
        }());
    </script>
{/block}
