// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The window containing a single Mail panel.
 */
Ext.define('Shopware.apps.ViisonCommonMailComposer.view.Window', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_common_mail_composer-window',
    cls: 'viison_common_mail_composer-window viison-common--window has--no-border',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_mail_composer/main',

    stateId: 'shopware-viison_common_mail_composer-window',
    width: 650,
    height: 500,
    modal: true,
    minimizable: false,
    maximizable: false,
    draggable: false,
    footerButton: false,
    layout: {
        align: 'stretch',
        type: 'hbox',
    },

    /**
     * A flag that controls whether the attachment field is shown of hidden.
     */
    hideAttachmentField: false,

    /**
     * The main initializer adding view components.
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = [
            this.createMailPanel(),
        ];

        // Create a load mask
        this.loadMask = new Ext.LoadMask(this, {
            msg: this.getViisonSnippet('window/load_mask_message'),
        });
        this.loadMask.hide();

        this.callParent(arguments);
    },

    /**
     * Create the main Panel containing all view components.
     *
     * @return The created view panel.
     */
    createMailPanel: function () {
        this.dataPanel = this.createPanel();

        this.dataPanel.addListener('sendMail', function () {
            var form = this.dataPanel.getForm();
            if (!form.isValid()) {
                return;
            }
            this.formData = form.getValues();
            this.sendMail();
        }, this);
        this.dataPanel.addListener('cancel', function () {
            this.close();
        }, this);

        return this.dataPanel;
    },

    createPanel: function () {
        return Ext.create('Shopware.apps.ViisonCommonMailComposer.view.Main', {
            mail: this.mail,
            cls: this.cls,
            hideAttachmentField: this.hideAttachmentField,
        });
    },

    sendMail: function () {},

});
