// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.view.success.Window', {

    extend: 'Enlight.app.Window',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_migration/main',

    autoShow: true,

    layout: 'border',
    height: '60%',
    width: 900,

    migrationExecutionResult: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('successWindow/title');

        this.items = [
            this.createHelpContainer(),
            this.createMigrationLog(),
        ];

        this.buttons = this.createButtons();

        this.callParent(arguments);
    },

    /**
     * @returns {object}
     */
    createHelpContainer: function () {
        return {
            xtype: 'container',
            cls: 'viison-common--explanation-area',
            region: 'north',
            items: [
                {
                    xtype: 'container',
                    cls: 'is--header',
                    html: this.getViisonSnippet('successWindow/description/header'),
                },
                {
                    xtype: 'container',
                    cls: 'is--paragraph',
                    html: this.getViisonSnippet('successWindow/description/paragraph'),
                },
            ],
        };
    },

    /**
     * @returns {object[]}
     */
    createButtons: function () {
        return [{
            xtype: 'button',
            text: this.getViisonSnippet('successWindow/button/close/text'),
            cls: 'primary',
            handler: function () {
                this.close();
            },
            scope: this,
        }];
    },

    /**
     * @returns {Shopware.apps.ViisonCommonMigration.component.MigrationLog}
     */
    createMigrationLog: function () {
        this.migrationLog = Ext.create('Shopware.apps.ViisonCommonMigration.component.MigrationLog', {
            region: 'center',
            width: '100%',
            migrationExecutionResult: this.migrationExecutionResult,
        });

        return this.migrationLog;
    },
});
