<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layers;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Orders20200601 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2020-06-01';
    }

    /**
     * post GET /api/orders
     */
    public function postIndexAction()
    {
        $data = $this->view->data;
        if (!is_array($data)) {
            return;
        }

        foreach ($data as &$order) {
            if (!isset($order['details'])) {
                continue;
            }
            foreach ($order['details'] as &$orderDetail) {
                $orderDetail['name'] = $orderDetail['articleName'];
                unset($orderDetail['articleName']);
            }
            unset($orderDetail);
        }
        unset($order);

        $this->view->data = $data;
    }
}
