<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Classes\Exceptions;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class IncompatibleAppVersionException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $message
     * @param string $snippetName
     * @param array $snippetArguments
     */
    public function __construct($message, $snippetName, array $snippetArguments = [])
    {
        parent::__construct(vsprintf($message, $snippetArguments));

        $this->setSnippetName($snippetName);
        $this->setSnippetNamespace('exceptions/viison_pickware_common/main');
        $this->setSnippetArguments($snippetArguments);
    }

    /**
     * @param string $requestingAppVersion
     * @param string $requiredAppVersion
     * @return self
     */
    public static function appVersionTooLow($requestingAppVersion, $requiredAppVersion)
    {
        return new self(
            'The version %s of the app you are using is too old to communicate with the plugins installed in the shop. Please upgrade the app to version %s or later.',
            'app_version_too_low',
            [
                $requestingAppVersion,
                $requiredAppVersion,
            ]
        );
    }

    /**
     * @param string $pluginName
     * @param string $pluginVersion
     * @param string $requiredPluginVersion
     * @return self
     */
    public static function pluginVersionTooLow($pluginName, $pluginVersion, $requiredPluginVersion)
    {
        return new self(
            'The version %s of the plugin %s installed in the shop is too old to communicate with the app you are using. Please upgrade the plugin to version %s or later.',
            'plugin_version_too_low',
            [
                $pluginVersion,
                $pluginName,
                $requiredPluginVersion,
            ]
        );
    }
}
