<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareCommon\Classes\Exceptions;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class NonUniqueDefaultCustomerGroupKeyException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @inheritdoc
     */
    public function __construct($message, $snippetName, array $snippetArguments = [])
    {
        parent::__construct(vsprintf($message, $snippetArguments));

        $this->setSnippetName($snippetName);
        $this->setSnippetNamespace('exceptions/viison_pickware_common/main');
        $this->setSnippetArguments($snippetArguments);
    }

    /**
     * @param string $customerGroupKey
     * @return self
     */
    public static function defaultCustomerGroupKeyNotUnique($customerGroupKey)
    {
        return new self(
            'The customer group key "%s" of the default shop is not unique. Please check the customer group settings in the shop backend.',
            'default_customer_group_key_not_unique',
            [
                $customerGroupKey,
            ]
        );
    }
}
